% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_paginate.R
\name{pag_tt_indices}
\alias{pag_tt_indices}
\alias{paginate_table}
\title{Pagination of a TableTree}
\usage{
pag_tt_indices(
  tt,
  lpp = 15,
  min_siblings = 2,
  nosplitin = character(),
  colwidths = NULL,
  max_width = NULL,
  verbose = FALSE
)

paginate_table(
  tt,
  page_type = "letter",
  font_family = "Courier",
  font_size = 12,
  lineheight = 1,
  landscape = FALSE,
  pg_width = NULL,
  pg_height = NULL,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  lpp,
  cpp,
  min_siblings = 2,
  nosplitin = character(),
  colwidths = NULL,
  tf_wrap = FALSE,
  max_width = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a
populated table.}

\item{lpp}{numeric. Maximum lines per page including (re)printed header and context rows}

\item{min_siblings}{numeric. Minimum sibling rows which must appear on either side of pagination row for a
mid-subtable split to be valid. Defaults to 2.}

\item{nosplitin}{character. List of names of sub-tables where page-breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{colwidths}{numeric vector. Column widths for use with vertical pagination.}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (`getOption("width")`). If set to `"auto"`,
the width of the table (plus any table inset) is used. Ignored
completely if `tf_wrap` is `FALSE`.}

\item{verbose}{logical(1). Should extra debugging messages be shown. Defaults
to \code{FALSE}.}

\item{page_type}{character(1).   Name   of  a  page  type.   See
`page_types`.   Ignored when  `pg_width` and  `pg_height`
are set directly.}

\item{font_family}{character(1). Name of a font family. An error
will be thrown if the family named is not monospaced. Defaults
to Courier.}

\item{font_size}{numeric(1). Fontsize, defaults to 12.}

\item{lineheight}{numeric(1). Lineheight, defaults to 1.}

\item{landscape}{logical(1). Should the  dimensions of `page_type`
be inverted  for landscape?  Defaults to  `FALSE`, ignored when
`pg_width` and `pg_height` are set directly.}

\item{pg_width}{numeric(1). Page width in inches.}

\item{pg_height}{numeric(1). Page height in inches.}

\item{margins}{numeric(4). Named numeric vector containing `'top'`,
`'bottom'`, `'left'`, and `'right'` margins in inches. Defaults
to `.5` inches for both vertical margins and `.75` for both
horizontal margins.}

\item{cpp}{numeric(1) or NULL. Width (in characters) of the pages for
horizontal pagination. \code{NULL} (the default) indicates no horizontal
pagination should be done.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}
}
\value{
for \code{pag_tt_indices} a list of paginated-groups of row-indices of \code{tt}. For \code{paginate_table},
The subtables defined by subsetting by the indices defined by \code{pag_tt_indices}.
}
\description{
Pagination of a TableTree
}
\note{
This is our first take on pagination. We will refine pagination in subsequent releases. Currently only
pagination in the row space work. Pagination in the column space will be added in the future.
}
\examples{

s_summary <- function(x) {
 if (is.numeric(x)) {
     in_rows(
         "n" = rcell(sum(!is.na(x)), format = "xx"),
         "Mean (sd)" = rcell(c(mean(x, na.rm = TRUE), sd(x, na.rm = TRUE)),
                             format = "xx.xx (xx.xx)"),
         "IQR" = rcell(IQR(x, na.rm = TRUE), format = "xx.xx"),
         "min - max" = rcell(range(x, na.rm = TRUE), format = "xx.xx - xx.xx")
     )
 } else if (is.factor(x)) {

     vs <- as.list(table(x))
     do.call(in_rows, lapply(vs, rcell, format = "xx"))

 } else (
     stop("type not supported")
 )
}


lyt <- basic_table() \%>\%
split_cols_by(var = "ARM") \%>\%
    analyze(c("AGE", "SEX", "BEP01FL", "BMRKR1", "BMRKR2", "COUNTRY"), afun = s_summary)

tbl <- build_table(lyt, ex_adsl)
tbl

nrow(tbl)

row_paths_summary(tbl)

tbls <- paginate_table(tbl)
mf <- matrix_form(tbl, indent_rownames = TRUE)
w_tbls <- propose_column_widths(mf) # so that we have the same column widths

tmp <- lapply(tbls, print, widths = w_tbls)

tmp <- lapply(tbls, function(tbli) {
  cat(toString(tbli, widths = w_tbls))
  cat("\n\n")
  cat("~~~~ PAGE BREAK ~~~~")
  cat("\n\n")
})


}
