% Generated by roxygen2 (4.0.2): do not edit by hand
\name{insert_front.rdeque}
\alias{insert_front.rdeque}
\title{Insert an element into the front of an rdeque}
\usage{
\method{insert_front}{rdeque}(d, e, ...)
}
\arguments{
\item{d}{rdeque to insert onto.}

\item{e}{element to insert.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
modified version of the rdeque.
}
\description{
Returns a version of the deque with the new element in the front position.
}
\details{
Runs in \eqn{O(1)} time worst-case. Does not modify the original rdeque.
}
\examples{
d <- rdeque()
d <- insert_front(d, "a")
d <- insert_front(d, "b")
print(d)

d2 <- insert_front(d, "c")
print(d2)
print(d)
}
\references{
Okasaki, Chris. Purely Functional Data Structures. Cambridge University Press, 1999.
}
\seealso{
\code{\link{without_front}} for removing the front element.
}

