% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.list.rpqueue}
\alias{as.list.rpqueue}
\title{Convert an rpqueue to a list}
\usage{
\method{as.list}{rpqueue}(x, ...)
}
\arguments{
\item{x}{rpqueue to convert.}

\item{...}{additional arguments passed to as.list after initial conversion to list.}
}
\value{
a list containing the elements of the rpqueue in front-to-back order.
}
\description{
Converts an rpqueue to a list, where the front of the queue becomes
the first element of the list, the second-from-front the second, and so on.
}
\details{
Runs in \eqn{O(N)} time in the size of the rpqueue, but the generated list is pre-allocated for efficiency.
}
\examples{
q <- rpqueue()
q <- insert_back(q, "a")
q <- insert_back(q, "b")

qlist <- as.list(q)
print(qlist)
}
\seealso{
\code{\link{as.data.frame.rpqueue}} and the generic \code{\link{as.list}}.
}

