% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc.R
\name{find_pandoc}
\alias{find_pandoc}
\title{Find the \command{pandoc} executable}
\usage{
find_pandoc(cache = TRUE, dir = NULL, version = NULL)
}
\arguments{
\item{cache}{Whether to search for \command{pandoc} again if a Pandoc
directory containing the \command{pandoc} executable of the expected
version (if provided) has been found previously. Search again if
\code{cache = FALSE}.}

\item{dir}{A character vector of potential directory paths under which
\command{pandoc} may be found. If not provided, this function searches for
\command{pandoc} from the environment variable \var{RSTUDIO_PANDOC} (the
RStudio IDE will set this variable to the directory of Pandoc bundled with
the IDE), the environment variable \var{PATH}, and the directory
\file{~/opt/pandoc/}.}

\item{version}{The version of Pandoc to look for (e.g., \code{"2.9.2.1"}). If
not provided, this function searches for the highest version under the
potential directories.}
}
\value{
A list containing the directory and version of Pandoc (if found).
}
\description{
Searches for the \command{pandoc} executable in a few places and use the
highest version found, unless a specific version is requested.
}
\note{
Usually you do not need to install Pandoc if you use the RStudio IDE,
  because the IDE has bundled a version of Pandoc. If you have installed a
  version of Pandoc by yourself and want to use this version instead, you may
  use the \code{dir} argument of this function.
}
\examples{
rmarkdown::find_pandoc()
rmarkdown::find_pandoc(dir = '~/Downloads/Pandoc')
rmarkdown::find_pandoc(version = '2.7.3')
}
