% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhoestimators.r
\name{beta_var}
\alias{beta_var}
\title{Estimate fixed-effect variance for Joint Rank Method (JR) in three-level
nested design.}
\usage{
beta_var(x, school, tauhat, v1, v2, v3, section, mat)
}
\arguments{
\item{x}{Data frame of covariates.}

\item{school}{A vector of cluster.}

\item{tauhat}{This is obtained from Rank-based fitting. 
\code{tauhat} here~~}

\item{v1}{This is 1, main diagonal element for correlation matrix of
observations. Correlation of an observation with itself is 1.}

\item{v2}{Intra-cluster correlation coefficient.}

\item{v3}{Intra-subcluster correlation coefficient.}

\item{section}{A vector of subclusters, nx1.}

\item{mat}{A matrix of numbers of observations in subclusters.  Dimension is
Ixmax(number ofsubclusters). Each row indicates one cluster.}
}
\value{
\item{var}{ The variance of fixed estimated. }
}
\description{
Fixed effect variance estimation for Joint Rank Method (JR). It assumes
Compound Symmetric (CS) structure of error terms. For k-level design, there
are k-1 intra/inter-class parameters to place in a correlation matrix of
errors.
}
\details{
Correlation coefficients are obtained using Moment Estimates. See Klole et.
al (2009), Bilgic (2012) and HM (2012)
}
\references{
Y. K. Bilgic. Rank-based estimation and prediction for mixed
effects models in nested designs. 2012. URL
http://scholarworks.wmich.edu/dissertations/40. Dissertation.

J. Kloke, J. W. McKean and M. Rashid. Rank-based estimation and associated
inferences for linear models with cluster correlated errors. Journal of the
American Statistical Association, 104(485):384-390, 2009.

T. P. Hettmansperger and J. W. McKean. Robust Nonparametric Statistical
Methods. Chapman Hall, 2012.
}
\author{
Yusuf Bilgic
}
