% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-entrace.R
\name{entrace}
\alias{entrace}
\alias{cnd_entrace}
\title{Add backtrace from error handler}
\usage{
entrace(cnd, ..., top = NULL, bottom = NULL)

cnd_entrace(cnd, ..., top = NULL, bottom = NULL)
}
\arguments{
\item{cnd}{When \code{entrace()} is used as a calling handler, \code{cnd} is
the condition to handle.}

\item{...}{Unused. These dots are for future extensions.}

\item{top}{The first frame environment to be included in the
backtrace. This becomes the top of the backtrace tree and
represents the oldest call in the backtrace.

This is needed in particular when you call \code{trace_back()}
indirectly or from a larger context, for example in tests or
inside an RMarkdown document where you don't want all of the
knitr evaluation mechanisms to appear in the backtrace.

If not supplied, the \code{rlang_trace_top_env} global option is
consulted. This makes it possible to trim the embedding context
for all backtraces created while the option is set. If knitr is
in progress, the default value for this option is
\code{knitr::knit_global()} so that the knitr context is trimmed out
of backtraces.}

\item{bottom}{The last frame environment to be included in the
backtrace. This becomes the rightmost leaf of the backtrace tree
and represents the youngest call in the backtrace.

Set this when you would like to capture a backtrace without the
capture context.

Can also be an integer that will be passed to \code{\link[=caller_env]{caller_env()}}.}
}
\description{
\code{entrace()} is a low level function. See \code{\link[=global_entrace]{global_entrace()}} for a
user-friendly way of enriching errors and other conditions from
your RProfile.
\itemize{
\item \code{entrace()} is meant to be used as a global handler. It enriches
conditions with a backtrace. Errors are saved to \code{\link[=last_error]{last_error()}}
and rethrown immediately. Messages and warnings are recorded into
\code{\link[=last_messages]{last_messages()}} and \code{\link[=last_warnings]{last_warnings()}} and let through.
\item \code{cnd_entrace()} adds a backtrace to a condition object, without
any other effect. It should be called from a condition handler.
}

\code{entrace()} also works as an \code{option(error = )} handler for
compatibility with versions of R older than 4.0.

When used as calling handler, rlang trims the handler invokation
context from the backtrace.
}
\examples{
quote({  # Not run

# Set `entrace()` globally in your RProfile
globalCallingHandlers(error = rlang::entrace)

# On older R versions which don't feature `globalCallingHandlers`,
# set the error handler like this:
options(error = rlang::entrace)

})
}
\seealso{
\code{\link[=global_entrace]{global_entrace()}} for configuring errors with
\code{entrace()}. \code{\link[=cnd_entrace]{cnd_entrace()}} to manually add a backtrace to a
condition.
}
\keyword{internal}
