% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{tensorprod}
\alias{tensorprod}
\title{Tensor product.}
\usage{
tensorprod(x, y)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{y}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}
}
\value{
A \code{LazyTensor} or a \code{ComplexLazyTensor}.
}
\description{
Tensor product of \code{LazyTensor}s - a binary operation.
}
\details{
If \code{x} and \code{y} are \code{LazyTensor}s encoding matrix,
respectively of length \code{nx*px} and \code{ny*py}, then \code{tensorprod(x, y)} encodes,
symbolically, the tensor product between matrix \code{x} and \code{y}, which is
a symbolic matrix of dimension (\code{nx*ny}, \code{px*py}).
}
\examples{
\dontrun{
x <- matrix(c(1, 2, 3), 2, 3)            # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')    # LazyTensor from matrix x, indexed by 'i'
y <- matrix(c(1, 1, 1), 2, 3)            # arbitrary R matrix, 200 rows, 3 columns
y_i <- LazyTensor(y, index = 'i')    # LazyTensor from matrix y, indexed by 'i'

tp_xy <- tensorprod(x_i, y_i) # symbolic (4, 9) matrix. 

}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
