% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{sinxdivx}
\alias{sinxdivx}
\title{Element-wise sin(x)/x function.}
\usage{
sinxdivx(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
depending on the input class.
}
\description{
Symbolic unary operation for element-wise sign.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{xlogx(x)} returns a \code{LazyTensor} that
encodes, symbolically, the element-wise sin(x)/x function of \code{x} (with value
0 at 0); else, computes \code{sin(x) / x}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
sindiv_x <- sinxdivx(x_i)           # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
