% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops_options.R
\name{rkeops_use_cpu}
\alias{rkeops_use_cpu}
\title{Enable GPU-computing when calling user-defined operators}
\usage{
rkeops_use_cpu(ncore = NULL)
}
\arguments{
\item{ncore}{integer, number of cores used by \code{rkeops} user-defined
operators to run computations in CPU mode. If \code{ncore = 0} then all
available cores are used. Default value is \code{NULL} which correspond to \code{0}.}
}
\value{
None
}
\description{
Set up \code{rkeops} options to use CPU computing when calling
user-defined operators.
}
\details{
\strong{Note 1:} By default, \code{rkeops} user-defined operators run computations
on CPU (even for GPU-compiled operators), thus calling the function
\code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}} is mandatory to run computations on GPU.

\strong{Note 2:} By default, in CPU mode, \code{rkeops} user-defined operators run
computations on all available cores for parallel computing. To control,
the number of cores used by \code{rkeops} user-defined operators, you can used
the input parameter \code{ncore}.
}
\examples{
\dontrun{
rkeops_use_cpu()
}
}
\seealso{
\code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}}, \code{\link[=set_rkeops_options]{set_rkeops_options()}}
}
\author{
Ghislain Durif
}
