% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{reduction.LazyTensor}
\alias{reduction.LazyTensor}
\title{Reduction operation.}
\usage{
reduction.LazyTensor(x, opstr, index, opt_arg = NA)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{opstr}{A \code{string} formula (like "Sum" or "Max").}

\item{index}{A \code{character} that should be either \strong{i} or \strong{j} to specify
whether if the reduction is indexed by \strong{i} (rows), or \strong{j} (columns).}

\item{opt_arg}{An optional argument : an \code{interger} (for "Kmin" reduction),
a \code{character}, \code{LazyTensor} or a \code{ComplexLazyTensor}.}
}
\value{
A matrix corresponding to the reduction wanted.
}
\description{
Applies a reduction to a \code{LazyTensor}.
}
\details{
\code{reduction.LazyTensor(x, opstr, index)} will :
\itemize{
\item{ if \strong{index = "i"}, return the \strong{opstr} reduction of \strong{x} over the
"i" indexes;}
\item{ if \strong{index = "j"}, return the \strong{opstr} reduction of \strong{x} over the
"j" indexes.}
}
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

red_x <- reduction.LazyTensor(x_i, "Sum", "i")
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
