% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_args.R
\name{parse_args}
\alias{parse_args}
\title{Parse formula argument list in triplet (type, dimension, position)}
\usage{
parse_args(formula, args)
}
\arguments{
\item{formula}{text string, an operator formula (see Details).}

\item{args}{vector of text string, formula input arguments (see Details).}
}
\value{
a list with different information about formula input arguments:
\itemize{
\item \code{args}: vector of text string, input parameter \code{args}.
\item \code{var_name} vector of text string, corresponding name of formula
arguments.
\item \code{var_type}: vector of text string, corresponding type of formula
arguments (among \code{Vi}, \code{Vj}, \code{Pm}).
\item \code{var_pos}: vector of integer, corresponding arguments positions.
\item \code{var_dim}: vector of integer, corresponding arguments inner dimensions.
\item \code{decl}: character string, either \code{"dim"} if \verb{Vi|Vj|Pm(<dim>)} argument
declaration convention is used, or \code{"pos_dim"} if
\verb{Vi|Vj|Pm(<pos>,<dim>)}  argument declaration convention is used.
}
}
\description{
The function \code{parse_args} formats KeOps formula arguments to be
understood by the C++ code.
}
\details{
Mathematical formula: \verb{sum_i e^(lambda*||x_i - y_j||^2)} where \code{x_i}, \code{y_j}
are 3d vectors, and \code{lambda} is a scaler parameter.

Corresponding KeOps formula and input parameters:

\if{html}{\out{<div class="sourceCode">}}\preformatted{formula = "Sum_Reduction(Exp(lambda * SqNorm2(x-y)), 0)"
args = c("x=Vi(3)", "y=Vj(3)", "lambda=Pm(1)")
}\if{html}{\out{</div>}}

Input arguments can be of different types:

|---------|-------------------------|-----------|\tabular{lll}{
   keyword \tab meaning \tab type \cr
   \code{Vi} \tab variable indexed by \code{i} \tab \code{0} \cr
   \code{Vj} \tab variable indexed by \code{j} \tab \code{1} \cr
   \code{Pm} \tab parameter \tab \code{2} \cr
   --------- \tab ------------------------- \tab ----------- \cr
}


An input parameters should be defined as follows \code{"x=YY(dim)"} or
\code{"x=YY(pos, dim)"} where \code{YY} can be \code{Vi}, \code{Vj} or \code{Pm}:
\itemize{
\item \code{dim} is the dimension of the variable or parameter. For \code{Vi} and \code{Vj},
the range of \code{i} or \code{j} is not known at compile time, only at runtime.
\item \code{pos} is the position of the variable as it will be supplied to the
operator, starting from \code{0}. This position should be specify for all
variable or none, if not specify the natural order in the vector \code{args} is
used.
}

For the formula \code{"Sum_Reduction(Exp(lambda * SqNorm2(x-y)), 0)"}, both
\code{args = c("x=Vi(3)", "y=Vj(3)", "lambda=Pm(1)")} and
\code{args <- c("x=Vi(0,3)", "y=Vj(1,3)", "beta=Vj(2,3)", "lambda=Pm(3,1)")} are
equivalent. When specifying the \code{pos} parameter, the natural order in the
vector \code{args} may not correspond to the order of the formula input arguments.

\strong{Note:} we recommend to use the \code{Vi(dim)} notation and let the position be
determined by the argument order.
}
\author{
Ghislain Durif
}
\keyword{internal}
