% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{mod}
\alias{mod}
\title{Element-wise modulo with offset function.}
\usage{
mod(x, ...)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}

\item{a}{A \code{LazyTensor}, a \code{ComplexLazyTensor} a vector of numeric values,
or a scalar value.}

\item{b}{A \code{LazyTensor}, a \code{ComplexLazyTensor} a vector of numeric values,
or a scalar value.}
}
\value{
An object of class \code{LazyTensor}.
}
\description{
Symbolic ternary operation for element-wise modulo with offset function.
}
\details{
\code{mod(x, a, b)} returns a \code{LazyTensor} that encodes, symbolically,
the element-wise modulo of \code{x} with modulus \code{a} and offset \code{b}. That is,
\code{mod(x, a, b)} encodes symbolically \code{x - a * floor((x - b)/a)}.
By default \code{b = 0}, so that \code{mod(x, a)} becomes equivalent to the R
function \code{\%\%}.
\code{a} and \code{b} may be fixed integers or floats, or other \code{LazyTensor}.
Broadcasting rules apply.

\strong{Note}

If \code{a} and \code{b} are not scalar values, these should have the same inner
dimension as \code{x}.

\strong{Warning}

Do not confuse with \code{Mod()}.
}
\examples{
\dontrun{
# basic example
D <- 3
M <- 100
N <- 150
P <- 200
x <- matrix(runif(M * D), M, D)
y <- matrix(runif(N * D), N, D)
z <- matrix(runif(P * D), P, D)
x_i <- LazyTensor(x, index = 'i')
y_j <- LazyTensor(y, index = 'j')
z_i <- LazyTensor(z, index = 'i')

# call mod function
mod_x72 <- mod(x_i, 7, 2)

# works also with LazyTensors with same inner dimension or dimension 1
mod_xyz <- mod(x_i, y_j, z_i)
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
