% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{min_argmin}
\alias{min_argmin}
\title{Min-ArgMin.}
\usage{
min_argmin(x, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the min-argmin reduction.
}
\description{
Min-ArgMin reduction.
}
\details{
\code{min_argmin(x, index)} will :
\itemize{
\item{ if \strong{index = "i"}, return the minimal values and its indices
of \strong{x} over the "i" indexes.}
\item{ if \strong{index = "j"}, return the minimal values and its indices
of \strong{x} over the "j" indexes.}
}

\strong{Note}

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

min_argmin_xi <- min_argmin(x_i, "i")  # min argmin reduction indexed by "i"
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
