% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{max_reduction}
\alias{max_reduction}
\title{Max reduction.}
\usage{
max_reduction(x, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the max reduction or an object of class
"LazyTensor" corresponding to a symbolic matrix, otherwise, depending on the
input class (see R default \code{min()} function).
}
\description{
Maximum reduction.
}
\details{
\code{max_reduction(x, index)} will return the max reduction of \strong{x}
indexed by \strong{index}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

max_red_x <- max_reduction(x_i, "i")  # max reduction indexed by "i"
}
}
\seealso{
\code{\link[=max]{max()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
