% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{max_argmax_reduction}
\alias{max_argmax_reduction}
\title{Max-ArgMax reduction.}
\usage{
max_argmax_reduction(x, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the max-argmax reduction.
}
\description{
Max-ArgMax reduction. Redirects to \code{max_argmax} function.
}
\details{
\code{max_argmax(x, index)} will :
\itemize{
\item if \strong{index = "i"}, return the maximal values of \strong{x} and its
indices over the \strong{i} indices;
\item if \strong{index = "j"}, return the maximal values of \strong{x} and its
indices over the \strong{j} indices.
}
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

max_argmax_red <- max_argmax_reduction(x_i, "i")  # max argmax reduction 
                                                  # indexed by "i"
}
}
\seealso{
\code{\link[=max_argmax]{max_argmax()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
