% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{max}
\alias{max}
\title{Maximum.}
\usage{
max(x, ...)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows), or \strong{j} (columns).
It can be NA (default) when no reduction is desired.}
}
\value{
A matrix corresponding to the max reduction or an object of class
"LazyTensor" corresponding to a symbolic matrix, otherwise, depending on the
input class (see R default \code{max()} function).
}
\description{
Maximum unary operation, or Max reduction.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{max(x, index)} will :
\itemize{
\item if \strong{index = "i"}, return the max reduction of \strong{x} over the "i"
indexes.
\item if \strong{index = "j"}, return the max reduction of \strong{x} over the "j"
indexes.
\item if \strong{index = NA} (default), return a new \code{LazyTensor} object
representing the max of the values of the vector.
}

\strong{Notes}

If \code{x} is not a \code{LazyTensor} it computes R default "max" function with
other specific arguments (see R default \code{max()} function).

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

max_xi <- max(x_i, "i")  # max reduction indexed by "i"
max_x <- max(x_i)        # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
