% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{matvecmult}
\alias{matvecmult}
\title{Matrix-vector product.}
\usage{
matvecmult(m, v)
}
\arguments{
\item{m}{A \code{LazyTensor} or a \code{ComplexLazyTensor} encoding a matrix.}

\item{v}{A \code{LazyTensor} or a \code{ComplexLazyTensor} encoding a parameter vector.}
}
\value{
A \code{LazyTensor} or a \code{ComplexLazyTensor}.
}
\description{
Matrix-vector product - a binary operation.
}
\details{
\code{matvecmult(m, v)} encodes, symbolically,
the matrix-vector product of \code{m} and \code{v}.

\strong{Note}

\code{m} and \code{v} should have the same inner dimension or \code{v} should be of
dimension 1.
}
\examples{
\dontrun{
m <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
v <- c(1,2,3)                       # arbitrary R vector of length 3
m_i <- LazyTensor(m, index = 'i')   # LazyTensor from matrix m, indexed by 'i'
Pm_v <- LazyTensor(v)               # parameter vector LazyTensor from v

mv_mult <- matvecmult(m_i, Pm_v)    # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
