% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{logsumexp}
\alias{logsumexp}
\title{Log-Sum-Exp reduction.}
\usage{
logsumexp(x, index, weight = NA)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor} indexed by 'i' and 'j'.}

\item{index}{A \code{character} corresponding to the reduction dimension that
should be either \strong{i} or \strong{j} to specify whether if the reduction
is indexed by \strong{i} (rows) or \strong{j} (columns).}

\item{weight}{An optional object (\code{LazyTensor} or \code{ComplexLazyTensor}) that
specifies scalar or vector-valued weights.}
}
\value{
A matrix corresponding to the Log-Sum-Exp reduction.
}
\description{
Log-Sum-Exp reduction.
}
\details{
\code{logsumexp(x, index, weight)} will:
\itemize{
\item{if \strong{index = i},}{ return the Log-Sum-Exp reduction of \strong{x}
over the \strong{i} indices (rows);}
\item{if \strong{index = j},}{ return the Log-Sum-Exp reduction of \strong{x}
over the \strong{j} indices (columns).}
}

\strong{Note}

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) 
x_i <- LazyTensor(x, index = 'i') 
y <- matrix(runif(100 * 3), 100, 3)
y_j <- LazyTensor(y, index = 'j')
w <- matrix(runif(100 * 3), 100, 3) # weight LazyTensor
w_j <- LazyTensor(w, index = 'j')

S_ij = sum((x_i - y_j)^2)                                           
logsumexp_xw <- logsumexp(S_ij, 'i', w_j) # logsumexp reduction 
                                          # over the 'i' indices
                                         
logsumexp_x <- logsumexp(S_ij, 'i')      # logsumexp reduction without
                                         # weight over the 'i' indices
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
