% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{is.LazyTensor}
\alias{is.LazyTensor}
\title{is.LazyTensor?}
\usage{
is.LazyTensor(x)
}
\arguments{
\item{x}{An object we want to know if it is a \code{LazyTensor}.}
}
\value{
A boolean, TRUE or FALSE.
}
\description{
Checks whether if the given input is a \code{LazyTensor} or not.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{is.LazyTensor(x)} returns TRUE, else,
returns FALSE.
}
\examples{
\dontrun{
# basic example
D <- 3
M <- 100
x <- matrix(runif(M * D), M, D)

# create LazyTensor
x_i <- LazyTensor(x, index = 'i')

# call is.LazyTensor
is.LazyTensor(x_i) # returns TRUE
is.LazyTensor(x)   # returns FALSE
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
