% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{is.LazyMatrix}
\alias{is.LazyMatrix}
\title{is.LazyMatrix?}
\usage{
is.LazyMatrix(x)
}
\arguments{
\item{x}{A \code{LazyTensor} object that we want to know if it is a \code{LazyMatrix}.}
}
\value{
A boolean, TRUE or FALSE.
}
\description{
Checks whether if the given input is a \code{LazyTensor} encoding
a matrix.
}
\details{
If \code{x} is a matrix \code{LazyTensor},
\code{is.LazyMatrix(x)} returns TRUE, else, returns FALSE.
}
\examples{
\dontrun{
# basic example
scal <- 3.14
cplx <- 2 + 3i
v <- rep(3, 10)
x <- matrix(runif(100 * 3), 100, 3)

# create LazyTensor and ComplexLazyTensor
scal_LT <- LazyTensor(scal)
cplx_LT <- LazyTensor(cplx)
v_LT <- LazyTensor(v)
x_i <- LazyTensor(x, index = 'i')

# call is.LazyMatrix
is.LazyMatrix(scal_LT) # returns FALSE
is.LazyMatrix(cplx_LT) # returns FALSE
is.LazyMatrix(v_LT) # returns FALSE
is.LazyMatrix(x_i) # returns TRUE
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
