% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{imag2complex}
\alias{imag2complex}
\title{Element-wise "imaginary 2 complex" operation.}
\usage{
imag2complex(x)
}
\arguments{
\item{x}{A \code{LazyTensor}.}
}
\value{
An object of class "ComplexLazyTensor".
}
\description{
Symbolic unary operation for element-wise "imaginary 2 complex".
}
\details{
\code{imag2complex(x)} returns a \code{ComplexLazyTensor} that encodes,
symbolically, the element-wise "imaginary 2 complex" of \code{x} (i.e. with
additional zero real part: \code{0 + x*i}).
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, "i")           # creating LazyTensor from matrix x,
                                    # indexed by 'i'

z <- imag2complex(x_i)              # ComplexLazyTensor object
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
