% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{fix_op_reduction}
\alias{fix_op_reduction}
\title{Fix internal reduction operation.}
\usage{
fix_op_reduction(reduction_op, with_weight = FALSE)
}
\arguments{
\item{reduction_op}{A text \code{string} corresponding to a reduction.}

\item{with_weight}{A \code{boolean} which is \code{TRUE} when there is an optional
argument corresponding to a weight argument.}
}
\value{
A text \code{string}.
}
\description{
Return the internal reduction operation.
}
\details{
\code{fix_op_reduction(reduction_op, with_weight)} will return the internal
reduction operation according to \code{reduction_op} and a possible optional weight
argument. Some advance operations defined at user level use in fact other
internal reductions:
\itemize{
\item If \code{reduction_op == "LogSumExp"}, the internal reduction operation
is \code{"Max_SumShiftExp"} or \code{"Max_SumShiftExpWeight"} depending on
\code{with_weight};
\item If \code{reduction_op == "SumSoftMax"}, the internal reduction operation
is \code{"Max_SumShiftExpWeight"};
\item Else, for every other value of \code{reduction_op}, the internal
reduction operation is \code{reduction_op}.
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
\keyword{internal}
