% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{extractT}
\alias{extractT}
\title{ExtractT.}
\usage{
extractT(x, m, d)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{m}{An \code{integer} corresponding to the starting index.}

\item{d}{An \code{integer} corresponding to the output inner dimension.}
}
\value{
A \code{LazyTensor}.
}
\description{
Insert a given value, vector of values or matrix of values in a symbolic
vector or matrix of zeros -
a unary operation.
}
\details{
If \code{x} is a \code{LazyTensor} encoding a vector (resp. a matrix),
\code{extractT(x, m, d)} encodes, symbolically, a \code{d}-inner-dimensional
vector (resp. matrix) of zeros in which is inserted \code{x},
at starting position \code{m}.

\strong{Note 1}

\code{x} can also encode a single value, in which case the operation works
the same way as in the case of a vector of values.

\strong{Note 2}

See @examples for a more concrete explanation of the use of \code{extractT()}.
}
\examples{
\dontrun{
# I - Three very rudimentary examples
# -----------------------------------

# 1) Let's say that you have a matrix `g` looking like this:
#      [,1] [,2]
# [1,]    1    4
# [2,]    2    5
# [3,]    3    6

# Convert it to LazyTensor:
g_i <- LazyTensor(g, index = 'i') # indexed by 'i' (for example)

# Then insert it in a matrix of inner dimension equal to 5,
# starting at index 1:
extT_g <- extractT(g_i, 1, 5)

# In this case, `extT_g` is a LazyTensor encoding, symbolically,
# the following matrix:
#      [,1] [,2] [,3] [,4] [,5]
# [1,]    0    1    4    0    0
# [2,]    0    2    5    0    0
# [3,]    0    3    6    0    0


# 2) Same principle with a LazyTensor encoding a vector:
v <- c(1, 2, 3, 1, 5)
Pm_v <- LazyTensor(v)

extT_Pm_v <- extract(Pm_v, 2, 3)

# In this case, `extT_Pm_v` is a LazyTensor encoding, symbolically,
# the following vector:
#       [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8]
# [1,]    0    1    2    3    1    5    0    0


3) Same again with a scalar value:
scal <- 3.14
Pm_scal <- Pm(scal) # `Pm(x)` is an aliases for `LazyTensor(x, index = NA)`

extT_Pm_scal <- extractT(Pm_scal, 2, 4)

# In this case, `extT_Pm_scal` is a LazyTensor encoding, symbolically,
# the following vector:
#       [,1] [,2] [,3] [,4]
# [1,]    0    0 3.14    0


# II - A more general example
# --------------------------- 

x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # LazyTensor from matrix x, 'i' indexed

m <- 2
d <- 7

extractT_x <- extractT(x_i, m, d)   # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
