% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops_options.R
\name{def_rkeops_options}
\alias{def_rkeops_options}
\title{Define a list of user-defined options for \code{rkeops} package}
\usage{
def_rkeops_options(
  backend = "CPU",
  device_id = -1,
  precision = "float32",
  verbosity = FALSE,
  debug = FALSE
)
}
\arguments{
\item{backend}{string character, \code{"CPU"} for CPU computing and \code{"GPU"}
for GPU computing. Default value is \code{"CPU"}.}

\item{device_id}{integer value corresponding to GPU id used for computation
(when using GPU computing). Default}

\item{precision}{string, character, precision for floating point
computations (\code{"float32"} for 32bits float or \code{"float64"} for
64bits float/double precision). Default value is \code{"float32"}.}

\item{verbosity}{\code{TRUE}-\code{FALSE} or \code{1}-\code{0} indicator (boolean) for
verbosity level. Default value is \code{0}.}

\item{debug}{\code{TRUE}-\code{FALSE} or \code{1}-\code{0} indicator (boolean) regarding
compilation debugging flag. \code{1} means that user-defined operators will
be compiled with a debug flag, and \code{0} means no debug flag.
Default value is \code{0}. DEPRECATED.}
}
\value{
a list (of class \code{rkeops_options}) with the following containing
named values corresponding to the function input parameters.
}
\description{
\code{rkeops} user-defined operators requires specific options to control
their behavior at runtime (precision, verbosity, use of GPU, debug flag).

The function \code{def_rkeops_options()} returns a list with default
(or specified) values for the corresponding options (see Details).
}
\details{
The aforementioned options correspond to the input parameters.

\strong{Note:} Default options are set up when loading \code{rkeops}. To reset
\code{rkeops} options to default or configure a particular option,
you should use the function \code{\link[=set_rkeops_options]{set_rkeops_options()}}.

Some helper functions are available to enable some options,
see \code{\link[=rkeops_use_float32]{rkeops_use_float32()}}, \code{\link[=rkeops_use_float64]{rkeops_use_float64()}},
\code{\link[=rkeops_use_cpu]{rkeops_use_cpu()}}, \code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}},
\code{\link[=rkeops_enable_verbosity]{rkeops_enable_verbosity()}}, \code{\link[=rkeops_disable_verbosity]{rkeops_disable_verbosity()}}.

\strong{Important:} GPU computing requires a Nvidia GPU and CUDA drivers.
It is recommended to use default GPU (i.e. \code{device_id = -1} or \code{0}) and
manage GPU assignment outside R by setting the environment variable
\code{CUDA_VISIBLE_DEVICES}.
}
\seealso{
\code{\link[=rkeops_use_float32]{rkeops_use_float32()}}, \code{\link[=rkeops_use_float64]{rkeops_use_float64()}},
\code{\link[=rkeops_use_cpu]{rkeops_use_cpu()}}, \code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}},
\code{\link[=rkeops_enable_verbosity]{rkeops_enable_verbosity()}}, \code{\link[=rkeops_disable_verbosity]{rkeops_disable_verbosity()}}
}
\author{
Ghislain Durif
}
\keyword{internal}
