% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keops_utils.R
\name{clean_rkeops}
\alias{clean_rkeops}
\title{Clean RKeOps build directory}
\usage{
clean_rkeops(warn = TRUE)
}
\arguments{
\item{warn}{boolean, if TRUE (default), warn user about cleaning.}
}
\value{
None
}
\description{
Remove all dynamic library files generated from compilations of user-defined
operators.
}
\details{
When compiling a user-defined operators, a shared object (\code{.so}) library
(or dynamic link library, \code{.dll}) file is created in RKeOps build
directory (located in the \code{.cache} folder in your home). For every
new operators, such a file is created.

Calling \code{clean_rkeops()} allows you to empty RKeOps build directory.

You can \code{\link[=get_rkeops_build_dir]{get_rkeops_build_dir()}} to get the path to RKeOps
build directory, and you can use \code{\link[=ls_rkeops_build_dir]{ls_rkeops_build_dir()}} to
list its content.
}
\examples{
\dontrun{
clean_rkeops()
}
}
\seealso{
\code{\link[=get_rkeops_build_dir]{get_rkeops_build_dir()}}, \code{\link[=ls_rkeops_build_dir]{ls_rkeops_build_dir()}}
}
\author{
Ghislain Durif
}
