% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{check_inner_dim}
\alias{check_inner_dim}
\title{Check inner dimensions for binary or ternary operations.}
\usage{
check_inner_dim(x, y, z = NA, check_type = "sameor1")
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{y}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{z}{A \code{LazyTensor} or a \code{ComplexLazyTensor} (optional, default = NA).}

\item{check_type}{A character string among "same" and "sameor1" (default),
to specify the desired type of inner dimension verification
(see @details section).}
}
\value{
A boolean TRUE or FALSE.
}
\description{
Verifies that the inner dimensions of two or three given \code{LazyTensor}
are the same.
}
\details{
If \code{x} and \code{y} are of class \code{LazyTensor} or \code{ComplexLazyTensor},
\code{check_inner_dim(x, y, check_type = "same")} returns \code{TRUE} if \code{x} and \code{y}
inner dimensions are the same, and \code{FALSE} otherwise, while
\code{check_inner_dim(x, y, check_type = "sameor1")} returns \code{TRUE} if \code{x} and \code{y}
inner dimensions are the same or if at least one of these equals 1,
and \code{FALSE} otherwise.
Same idea with a third input \code{z}.
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
\keyword{internal}
