% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{atan2}
\alias{atan2}
\title{Element-wise 2-argument arc-tangent.}
\usage{
atan2(x, y)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}

\item{y}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
depending on the input class (see R default \code{atan2()} function).
}
\description{
Symbolic binary operation for element-wise 2-argument arc-tangent function.
}
\details{
If \code{x} or \code{y} is a \code{LazyTensor}, \code{atan2(x, y)} returns a \code{LazyTensor}
that encodes, symbolically, the element-wise atan2 of \code{x} and \code{y}.
(In case one of the arguments is a vector or a scalar, it is first converted
to LazyTensor).
If none of the arguments is a LazyTensor, it computes R default atan2 function.

\strong{Note}

\code{x} and \code{y} input arguments should have the same inner dimension.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
y <- matrix(runif(250 * 3), 250, 3) # arbitrary R matrix, 250 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
y_j <- LazyTensor(y, index = 'j')   # creating LazyTensor from matrix y, 
                                    # indexed by 'j'
                                    
Atan2_xy <- atan2(x_i, y_j)         # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
