% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{argmin}
\alias{argmin}
\title{ArgMin.}
\usage{
argmin(x, index = NA)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).
It can be NA (default) when no reduction is desired.}
}
\value{
A matrix corresponding to the argmin reduction or an object of class
"LazyTensor" corresponding to a symbolic matrix.
}
\description{
ArgMin unary operation, or ArgMin reduction.
}
\details{
\code{argmin(x, index)} will :
\itemize{
\item if \strong{index = "i"}, return the argmin reduction of \strong{x} over the "i"
indexes.
\item if \strong{index = "j"}, return the argmin reduction of \strong{x} over the "j"
indexes.
\item if \strong{index = NA} (default), return a new \code{LazyTensor} object
representing the argmin  of the values of the vector.
}

\strong{Note}

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

argmin_xi <- argmin(x_i, "i")  # argmin reduction indexed by "i"
argmin_x <- argmin(x_i)        # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
