% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{Mod}
\alias{Mod}
\title{Element-wise absolute value (or modulus).}
\usage{
Mod(z)
}
\arguments{
\item{z}{A \code{ComplexLazyTensor}, or any type of values accepted by R default
\code{Mod()} function.}
}
\value{
A \code{LazyTensor}.
}
\description{
Symbolic unary operation for element-wise absolute value (or modulus).
}
\details{
If \code{z} is a \code{ComplexLazyTensor}, \code{Mod(z)} returns a \code{LazyTensor} that
encodes, symbolically, the element-wise absolute value (or modulus) of \code{z} ;
else, computes R default \code{Mod()} function.
}
\examples{
\dontrun{
z <- matrix(1i^ (-6:5), nrow = 4)                     # complex 4x3 matrix
z_i <- LazyTensor(z, index = 'i', is_complex = TRUE)  # ComplexLazyTensor

Mod_z_i <- Mod(z_i)                                   # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
