% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{Im}
\alias{Im}
\title{Element-wise imaginary part of complex.}
\usage{
Im(z)
}
\arguments{
\item{z}{A \code{ComplexLazyTensor} or any type of values accepted by R default
\code{Im()} function.}
}
\value{
An object of class "ComplexLazyTensor" if the function is called with
a \code{ComplexLazyTensor}, else see R default \code{Im()} function.
}
\description{
Symbolic unary operation for element-wise imaginary part of complex.
}
\details{
If \code{z} is a \code{ComplexLazyTensor}, \code{Im(z)} returns a \code{ComplexLazyTensor}
that encodes, symbolically, the element-wise imaginary part of complex \code{z} ;
else, computes R default \code{Im()} function.
}
\examples{
\dontrun{
z <- matrix(2 + 1i^ (-6:5), nrow = 4)         # complex matrix
z_i <- LazyTensor(z, "i", is_complex = TRUE)  # creating ComplexLazyTensor

Im_z <- Im(z_i)                               # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
