% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{Conj}
\alias{Conj}
\title{Element-wise complex conjugate.}
\usage{
Conj(z)
}
\arguments{
\item{z}{A \code{ComplexLazyTensor}, or any type of values accepted by R default
\code{Conj()} function.}
}
\value{
A \code{ComplexLazyTensor}.
}
\description{
Symbolic unary operation for element-wise complex conjugate.
}
\details{
If \code{z} is a \code{ComplexLazyTensor}, \code{Conj(z)} returns a \code{ComplexLazyTensor}
that encodes symbolically, the element-wise complex conjugate of \code{z} ;
else, computes R default \code{Conj()} function.
}
\examples{
\dontrun{
z <- matrix(1i^ (-6:5), nrow = 4)                     # complex 4x3 matrix
z_i <- LazyTensor(z, index = 'i', is_complex = TRUE)  # ComplexLazyTensor

Conj_z_i <- Conj(z_i)                                 # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
