% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rex2arma.R
\name{rex2arma}
\alias{rex2arma}
\title{R Expression to RcppArmadillo}
\usage{
rex2arma(
  text,
  fname = if (is.function(text) && is.symbol(substitute(text))) sprintf("\%s_arma_",
    deparse(substitute(text))) else "rex_arma_",
  exec = 0,
  copy = TRUE,
  rebuild = FALSE,
  inpvars = NULL,
  outvars = NULL,
  verbose = FALSE,
  includes = character(),
  call2a = rex2arma::call2a,
  envir = parent.frame()
)
}
\arguments{
\item{text}{A string with a code or an R expression
or an R function or a plain code.}

\item{fname}{A string with a name for Rcpp function (if NULL,
default to rex_arma_)}

\item{exec}{An integer from {-1, 0, 1, 2} (default 0).}

\item{copy}{A logical saying to make or not a local copy of input
vectors/matrices (default TRUE, i.e. make a copy).}

\item{rebuild}{A logical saying to rebuild or not previous Rcpp code
(default FALSE, i.e. no rebuild if \code{text} does not change)}

\item{inpvars}{A character vector with names of input variables
(default NULL, i.e. this list is automatically constructed)}

\item{outvars}{A character vector with names of output variables.
If there are many, they are put in a list. If \code{outvars} is named,
The names are used for naming returned list items.}

\item{verbose}{Logical scalar. It also  passed through to the Rcpp:sourceCppp() call.}

\item{includes}{Character vector containing code included in generated
C++ code before the targeted function.}

\item{call2a}{An environment defining translation of R functions to C++ ones.}

\item{envir}{An environment where variable for parameter prototyping lives.}
}
\value{
a string with generated code or the result of calculation
 depending on \code{exec} (cf. Details)
}
\description{
Translate a (simple) R code to RcppArmadillo code.
}
\details{
If the \code{text} is a string it is parsed. If not, it must
be a valid R expression or a function or a plain code (cf. Examples).

If \enumerate{
 \item \code{exec==0}: (default) the full RcppArmadillo code is not executed
   it is just returned as a string;
 \item \code{exec==-1}: the same as 0 but only translated code is returned,
   i.e. without preamble, includes and Rcpp call;
 \item \code{exec==1}: the Rcpp function is created in the calling
   environment but not executed.
 \item \code{exec==2}: the c++ function is created and called too.
   Its output is returned as the result of rex2arma() call.
}

If \code{copy==TRUE}, objects inside the cpp code are created
with memory copying.
If \code{copy==FLASE}, the calculations are made "in place"
(be carefull with that! The side effects can be very surprising).
The argument \code{rebuild} is passed through to cppFunction()

If \code{text} is a function, the argument list is taken
from that function and \code{inpvars} is not consulted.

If \code{outvars} is  NULL, all variables that appear on the left hand side
will be returned. If \code{text} is a function,
the output is taken from it and \code{outvars} is not consulted.
}
\section{Warning}{

The converted R code is executed in a dedicated environement.
 So it is better to call rex2arma when input variables are small
 vectors/matrices.

Input variables must be of most generic type during \code{rex2arma()} call.
For example, if \code{a} is supposed to be float, don't set just
 \code{a <- 1:2} which will be of type \code{integer}. Instead use
 \code{a <- 1:2+0.1} or something alike.
}

\section{Limitations}{

\enumerate{
 \item no implicit vector recycling in term-by-term operations
 \item symbols "T" and "F" are converted to "true" and "false"
 \item no global assignement \code{<<-}
 \item and last but not least, no guaranty that produced code works as
  expected even if it compiles without error
}
Allowed operators and calls are:
  binary: '+', '-', '*', '/', '%*%', '%o%', logical operators
  calls: t(), [qr.]solve(), ginv(), diag()
         nrow(), ncol(), norm()
  element-wise mathematical functions having the
    same syntaxe in R and Armadillo: sqrt(), abs() etc.;
}

\section{Code conventions}{

R variables are considered as one of the following type (typeof(var) -> Rcpp; arma)
(-"- means that the type has no its own equivalent in arma and kept as in Rcpp):
\enumerate{
\item list -> List; -"-
\item character -> Character; -"-
\item numeric -> double; -"-
\item double -> double; -"-"
\item integer -> int; sword
\item function -> Function; -"-
\item logical -> Logical; -"-
}

Depending on dimension of {numeric, integer, character, logical} variable
it can be one the following structures in Rcpp/arma:
Rcpp / Armadillo types:
- {Integer,Numeric,Complex,Character}Vector/{ivec,vec,cx_vec,-"-}
- {Integer,Numeric,Complex,Character}Matrix/{imat,mat,cx_mat,-"-}
}

\examples{
a=1:3; b=a+3; # NB. Inputs a and b are defined before a call to rex2arma()
# \code{text} is a string:
code=rex2arma("a+b", exec=0)
cat(code);

# \code{text} is a function
f=function(a, b) a+b
code=rex2arma(f, exec=0)

# \code{text} is a plain R code
code=rex2arma(a+b, exec=0)
code=rex2arma({inner=a\%*\%b; outer=a\%o\%b}, exec=0)

# \code{text} is an expression
e=parse(text="{s=a+b; d=a-b}")
code=rex2arma(e, exec=0)

# to execute the produced code:
#(result=eval(parse(text=code)))
# or simply
#(result=rex2arma("a+b", exec=2))
}
