% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_spec.r
\name{print.table_spec}
\alias{print.table_spec}
\title{Prints the table spec}
\usage{
\method{print}{table_spec}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The table spec.}

\item{...}{Additional parameters to pass to the underlying print function.}

\item{verbose}{Whether to print in verbose form, which is similar to 
a list.  Default is FALSE, which prints in summary form.}
}
\value{
The table spec, invisibly.
}
\description{
A function to print the table spec.
The \strong{print} function will print the table spec in summary 
form.  To view all parameters, set the \code{verbose} parameter to TRUE.
}
\examples{
library(magrittr)

# Create Table
tbl <- create_table(mtcars) \%>\% 
  define(mpg, label = "Miles Per Gallon", width = .5) \%>\% 
  define(cyl, label = "Cylinders") \%>\% 
  titles("Table 6.4", "MTCARS Sample Table") \%>\% 
  footnotes("* Motor Trend, 1974")
  
tbl

# A table specification:
# - data: data.frame 'mtcars' 32 rows 11 cols
# - show_cols: all
# - use_attributes: all
# - title 1: 'Table 6.4'
# - title 2: 'MTCARS Sample Table'
# - footnote 1: '* Motor Trend, 1974'
# - define: mpg 'Miles Per Gallon' width=0.5 
# - define: cyl 'Cylinders' 
}
\seealso{
\code{\link{create_table}} function to create a table specification.

Other table: 
\code{\link{column_defaults}()},
\code{\link{create_table}()},
\code{\link{define}()},
\code{\link{spanning_header}()},
\code{\link{stub}()}
}
\concept{table}
