% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-bitbucket.R
\name{install_bitbucket}
\alias{install_bitbucket}
\title{Install a package directly from Bitbucket}
\usage{
install_bitbucket(
  repo,
  ref = "HEAD",
  subdir = NULL,
  auth_user = bitbucket_user(),
  password = bitbucket_password(),
  host = "api.bitbucket.org/2.0",
  dependencies = NA,
  upgrade = c("default", "ask", "always", "never"),
  force = FALSE,
  quiet = FALSE,
  build = TRUE,
  build_opts = c("--no-resave-data", "--no-manual", "--no-build-vignettes"),
  build_manual = FALSE,
  build_vignettes = FALSE,
  repos = getOption("repos"),
  type = getOption("pkgType"),
  ...
)
}
\arguments{
\item{repo}{Repository address in the format
\verb{username/repo[/subdir][@ref]}. Alternatively, you can
specify \code{subdir} and/or \code{ref} using the respective parameters
(see below); if both are specified, the values in \code{repo} take
precedence.}

\item{ref}{Desired git reference; could be a commit, tag, or branch name.
Defaults to HEAD.}

\item{subdir}{Subdirectory within repo that contains the R package.}

\item{auth_user}{your account username if you're attempting to install
a package hosted in a private repository (and your username is different
to \code{username}). Defaults to the \code{BITBUCKET_USER} environment
variable.}

\item{password}{your password. Defaults to the \code{BITBUCKET_PASSWORD}
environment variable. See details for further information on setting
up a password.}

\item{host}{GitHub API host to use. Override with your GitHub enterprise
hostname, for example, \code{"github.hostname.com/api/v3"}.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).

The value "soft" means the same as \code{TRUE}, "hard" means the same as \code{NA}.

You can also specify dependencies from one or more additional fields,
common ones include:
\itemize{
\item Config/Needs/website - for dependencies used in building the pkgdown site.
\item Config/Needs/coverage for dependencies used in calculating test coverage.
}}

\item{upgrade}{Should package dependencies be upgraded? One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \verb{R CMD build}, only used when \code{build} is \code{TRUE}.}

\item{build_manual}{If \code{FALSE}, don't build PDF manual ('--no-manual').}

\item{build_vignettes}{If \code{FALSE}, don't build package vignettes ('--no-build-vignettes').}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.}

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This function is vectorised so you can install multiple packages in
a single command.
}
\details{
To install from a private repo, or more generally, access the
Bitbucket API with your own credentials, you will need to get an access
token. You can create an access token following the instructions found in
the
\href{https://support.atlassian.com/bitbucket-cloud/docs/app-passwords/}{Bitbucket
App Passwords documentation}. The App Password requires read-only access to
your repositories and pull requests. Then store your password in the
environment variable \code{BITBUCKET_PASSWORD} (e.g. \code{evelynwaugh:swordofhonour})

Note that on Windows, authentication requires the "libcurl" download
method. You can set the default download method via the
\code{download.file.method} option:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(download.file.method = "libcurl")
}\if{html}{\out{</div>}}

In particular, if unset, RStudio sets the download method to "wininet".
To override this, you might want to set it to "libcurl" in your
R profile, see \link[base:Startup]{base::Startup}. The caveat of the "libcurl" method is
that it does \emph{not} set the system proxies automatically, see
"Setting Proxies" in \code{\link[utils:download.file]{utils::download.file()}}.
}
\examples{
\dontrun{
install_bitbucket("sulab/mygene.r@default")
install_bitbucket("djnavarro/lsr")
}
}
\seealso{
Bitbucket API docs:
\url{https://confluence.atlassian.com/bitbucket/use-the-bitbucket-cloud-rest-apis-222724129.html}

Other package installation: 
\code{\link{install_bioc}()},
\code{\link{install_cran}()},
\code{\link{install_dev}()},
\code{\link{install_github}()},
\code{\link{install_gitlab}()},
\code{\link{install_git}()},
\code{\link{install_local}()},
\code{\link{install_svn}()},
\code{\link{install_url}()},
\code{\link{install_version}()}
}
\concept{package installation}
