library(rearrr)
context("shuffle_hierarchy")


test_that("shuffle_hierarchy()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    'a' = rep(1:2, each = 8),
    'b' = rep(1:4, each = 4),
    'c' = rep(1:8, each = 2),
    'd' = 1:16
  )

  ## Testing 'shuffle_hierarchy(df, group_cols = c('a', 'b...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(98)
  # Assigning output
  output_19148 <- shuffle_hierarchy(df, group_cols = c('a', 'b', 'c', 'd'))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["a"]],
    c(2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["b"]],
    c(4L, 4L, 4L, 4L, 3L, 3L, 3L, 3L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["c"]],
    c(8L, 8L, 7L, 7L, 6L, 6L, 5L, 5L, 1L, 1L, 2L, 2L, 4L, 4L, 3L, 3L),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(15L, 16L, 13L, 14L, 12L, 11L, 10L, 9L, 1L, 2L, 3L, 4L, 7L, 8L, 5L, 6L),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'shuffle_hierarchy(df, group_cols = c('a', 'b...'     ####



  ## Testing 'shuffle_hierarchy( data = df, group_cols = c...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(98)
  # Assigning output
  output_16988 <- shuffle_hierarchy(
      data = df,
      group_cols = c('a', 'b', 'c', 'd'),
      cols_to_shuffle = c('a', 'c')
    )
  # Testing class
  expect_equal(
    class(output_16988),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16988[["a"]],
    c(2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L),
    tolerance = 1e-4)
  expect_equal(
    output_16988[["b"]],
    c(3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L),
    tolerance = 1e-4)
  expect_equal(
    output_16988[["c"]],
    c(5L, 5L, 6L, 6L, 7L, 7L, 8L, 8L, 1L, 1L, 2L, 2L, 3L, 3L, 4L, 4L),
    tolerance = 1e-4)
  expect_equal(
    output_16988[["d"]],
    c(9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16988),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16988),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16988),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16988),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16988)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'shuffle_hierarchy( data = df, group_cols = c...'     ####

  ## Testing 'shuffle_hierarchy(df, group_cols = c('a', 'b...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_10268 <- shuffle_hierarchy(df, group_cols = c('a', 'b'), leaf_has_groups = FALSE)
  # Testing class
  expect_equal(
    class(output_10268),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10268[["a"]],
    c(2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_10268[["b"]],
    c(4, 4, 3, 3, 4, 3, 4, 3, 2, 2, 1, 2, 1, 2, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_10268[["c"]],
    c(7, 7, 6, 6, 8, 5, 8, 5, 4, 4, 1, 3, 2, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_10268[["d"]],
    c(14, 13, 11, 12, 15, 9, 16, 10, 8, 7, 2, 5, 3, 6, 4, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10268),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10268),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10268),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10268),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10268)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'shuffle_hierarchy(df, group_cols = c('a', 'b...'     ####

  # If leaf col is not in cols_to_shuffle
  # last column should be considered a group (because it is not the leaf)

  ## Testing 'shuffle_hierarchy(df, group_cols = c('a', 'b...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19782 <- shuffle_hierarchy(df, group_cols = c('a', 'b'), cols_to_shuffle = 'a', leaf_has_groups = FALSE)
  # Testing class
  expect_equal(
    class(output_19782),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19782[["a"]],
    c(2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["b"]],
    c(3, 3, 3, 3, 4, 4, 4, 4, 1, 1, 1, 1, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["c"]],
    c(5, 5, 6, 6, 7, 7, 8, 8, 1, 1, 2, 2, 3, 3, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["d"]],
    c(9, 10, 11, 12, 13, 14, 15, 16, 1, 2, 3, 4, 5, 6, 7, 8),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19782),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19782),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19782),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19782),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19782)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'shuffle_hierarchy(df, group_cols = c('a', 'b...'     ####

})


test_that("fuzz testing shuffle_hierarchy()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    'a' = rep(1:2, each = 8),
    'b' = rep(1:4, each = 4),
    'c' = rep(1:8, each = 2),
    'd' = 1:16
  )

  # Generate expectations for 'shuffle_hierarchy'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = shuffle_hierarchy,
  #   args_values = list(
  #     "data" = list(df, c(1,2,3), NA),
  #     "group_cols" = list(c('a', 'b', 'c', 'd'), c(1, 2, 3, 4), NA),
  #     "cols_to_shuffle" = list(c('a', 'b', 'c', 'd'), c('b', 'c'), 2, NA),
  #     "leaf_has_groups" = list(TRUE, FALSE, NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )

  ## Testing 'shuffle_hierarchy'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["a"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["b"]],
    c(1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["c"]],
    c(2, 2, 1, 1, 3, 3, 4, 4, 6, 6, 5, 5, 8, 8, 7, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(3, 4, 2, 1, 6, 5, 8, 7, 11, 12, 10, 9, 15, 16, 14, 13),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = c(1, 2, 3), group_c...
  # Changed from baseline: data = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(shuffle_hierarchy(data = c(1, 2, 3), group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = NA, group_cols = c(...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(shuffle_hierarchy(data = NA, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = NULL, group_cols = ...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(shuffle_hierarchy(data = NULL, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: group_cols = c(1, 2, ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = c(1, 2, 3, 4), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'group_cols': Must be of type 'character', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = NA...
  # Changed from baseline: group_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = NA, cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'group_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = NU...
  # Changed from baseline: group_cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = NULL, cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'group_cols': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: cols_to_shuffle = c("...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("b", "c"), leaf_has_groups = TRUE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["a"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["b"]],
    c(2, 2, 2, 2, 1, 1, 1, 1, 3, 3, 3, 3, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["c"]],
    c(3, 3, 4, 4, 2, 2, 1, 1, 6, 6, 5, 5, 8, 8, 7, 7),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["d"]],
    c(5, 6, 7, 8, 3, 4, 1, 2, 11, 12, 9, 10, 15, 16, 13, 14),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: cols_to_shuffle = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = 2, leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols_to_shuffle': Must be of type 'character', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: cols_to_shuffle = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = NA, leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols_to_shuffle': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: cols_to_shuffle = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = NULL, leaf_has_groups = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols_to_shuffle': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: leaf_has_groups = FALSE
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = FALSE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["a"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["b"]],
    c(1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["c"]],
    c(2, 2, 1, 1, 3, 3, 4, 4, 6, 6, 5, 5, 8, 8, 7, 7),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["d"]],
    c(3, 4, 2, 1, 6, 5, 8, 7, 11, 12, 10, 9, 15, 16, 14, 13),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("a", "b", "c", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(16L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: leaf_has_groups = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'leaf_has_groups': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shuffle_hierarchy(data = df, group_cols = c(...
  # Changed from baseline: leaf_has_groups = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(shuffle_hierarchy(data = df, group_cols = c("a", "b", "c", "d"), cols_to_shuffle = c("a", "b", "c", "d"), leaf_has_groups = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'leaf_has_groups': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'shuffle_hierarchy'                                     ####
  #

})

