% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.snapshot.R
\name{read.snapshot}
\alias{read.snapshot}
\title{Reads IAMC-style .csv files obtained as a IIASA snapshot into a quitte data frame,
filtering the data. This function is helpful if the csv file is large and R runs out
of memory loading it completely. This function requires head, tail and grep on your system.
If not supported, use read.quitte().}
\usage{
read.snapshot(file, keep = list(), filter.function = NULL)
}
\arguments{
\item{file}{Path of single IAMC-style .csv/.mif file}

\item{keep}{list with quitte columns as names and data points that should be kept. Using 'grep',
this list is used to extract the data before reading it into R. The more you restrict the data here,
the faster the data is read.}

\item{filter.function}{A function used to filter data during read, see read.quitte description.}
}
\value{
A quitte data frame.
}
\description{
Reads IAMC-style .csv files obtained as a IIASA snapshot into a quitte data frame,
filtering the data. This function is helpful if the csv file is large and R runs out
of memory loading it completely. This function requires head, tail and grep on your system.
If not supported, use read.quitte().
}
\examples{
\dontrun{
read.filter.snapshot("snapshot.csv", list(scenario = c("CurPol", "NDC"), region = "World"))
}

}
\author{
Oliver Richters
}
