% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.levels.R
\name{order.levels}
\alias{order.levels}
\alias{order.levels_}
\title{Order data frame factor levels.}
\usage{
order.levels(df, ..., drop.extra.levels = TRUE)

order.levels_(df, dots, drop.extra.levels = TRUE)
}
\arguments{
\item{df}{A data frame (or quitte object).}

\item{...}{Name-value pairs assigning level order to factor columns.}

\item{drop.extra.levels}{If \code{TRUE} (default) levels not present in the
factor are silently dropped.}

\item{dots}{A named list of factor columns and corresponding levels.}
}
\value{
A data frame (or quitte object, same as \code{data}).
}
\description{
Arranges the levels of data frame columns in a given order. Non-factor
columns are silently converted.
}
\examples{
require(dplyr)
str(df <- tibble(UPPER = LETTERS[3:1], lower = factor(letters[24:26]),
                     value = 1:3))
str(order.levels(df, UPPER = LETTERS[1:3], lower = letters[26:20]))
str(order.levels_(df, list(UPPER = LETTERS[1:3], lower = letters[26:23]),
                  drop.extra.levels = FALSE))

}
\author{
Michaja Pehl
}
