% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate.R
\name{duplicate}
\alias{duplicate}
\alias{duplicate_}
\title{Duplicate rows}
\usage{
duplicate(data, ...)

duplicate_(data, column)
}
\arguments{
\item{data}{A \verb{data frame} or \code{quitte} object.}

\item{..., column}{A key-value pair of the column to modify.}
}
\value{
A \verb{data frame} or \code{quitte} object, same as input.
}
\description{
Duplicate rows in a data frame, modifying a specified column.
}
\examples{
require(dplyr)
(data <- tibble(region   = rep(c('AFR', 'CHN'), 2),
                    variable = paste('Var', c(1, 1, 2, 2)),
                    value    = 1:4))

data \%>\% duplicate(region = 'World')
}
