% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.as.list.R
\name{df.as.list}
\alias{df.as.list}
\title{Data Frame as List}
\usage{
df.as.list(df, names = 1, x = 2)
}
\arguments{
\item{df}{A data frame.}

\item{names}{Index used for naming list items.  Integer or character, must
work with \code{df[[names]]}.  Defaults to the first data frame column.}

\item{x}{Index used for list items.  Integer or character, must work with
\code{df[[x]]}.  Defaults to the second data frame column.}
}
\value{
A list.
}
\description{
Data Frame as List
}
\examples{
(df <- data.frame(
    modules = c('power', 'macro', 'welfare', 'PE_FE_parameters',
                'initialCap', 'aerosols'),
    `*` = c('IntC', 'singleSectorGr', 'utilitarian', 'iea2014', 'on',
            'exoGAINS'),
    check.names = FALSE
))

df.as.list(df, 'modules', '*')

}
