% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCumulatedDiscount.R
\name{calcCumulatedDiscount}
\alias{calcCumulatedDiscount}
\title{Calculates the cumulated discounted time series}
\usage{
calcCumulatedDiscount(
  data,
  nameVar = "Consumption",
  nameDisrate = "Interest Rate t/(t-1)|Real",
  discount = 0.05,
  fixYear = "none"
)
}
\arguments{
\item{data}{a quitte object containing consumption values - consumption has
to be named "Consumption"}

\item{nameVar}{name of the variable to be cumulated (and discounted)}

\item{nameDisrate}{Name of the variable containing the discount rate}

\item{discount}{The discount rate: either a numeric value, or 'BAU' to
choose the discount rate supplied in nameDisrate}

\item{fixYear}{From the discounted time series, substract the value in year
fixYear, if fixYear is not 'none'}
}
\value{
cumulated discounted values for each scenario, model, region (quitte
object)
}
\description{
Discount and cumulated a times series - gives the time series of the net
present value (NPV). Baseyear for the NPV is the first period.
}
\examples{

  \dontrun{
    erg <- calcCumulatedDiscount(data, disRate=0.03)
  }

}
\author{
Anselm Schultes
}
