% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.quitte.R
\name{read.quitte}
\alias{read.quitte}
\title{Read IAMC-style .csv or .xlsx files}
\usage{
read.quitte(
  file,
  sep = NULL,
  quote = "",
  na.strings = c("UNDF", "NA", "N/A", "n_a"),
  convert.periods = FALSE,
  check.duplicates = TRUE,
  factors = TRUE,
  drop.na = FALSE,
  comment = "#"
)
}
\arguments{
\item{file}{Path of IAMC-style .csv or xlsx. file or vector of paths to read.}

\item{sep}{Column separator, defaults to ";" in read_mif_header().}

\item{quote}{Quote characters, empty by default.}

\item{na.strings}{Entries to interpret as NA; defaults to
\code{c("UNDF", "NA", "N/A", "n_a")}}

\item{convert.periods}{If \code{TRUE}, periods are converted to
\code{\link[base:DateTimeClasses]{POSIXct}}.  If \code{FALSE} (the default), periods
are numerical.}

\item{check.duplicates}{If \code{TRUE} a duplicates check will be performed on the
data.  For time- and memory-critical applications this can be switched
off.}

\item{factors}{Return columns as factors (\code{TRUE}, the default) or not.}

\item{drop.na}{Should \code{NA} values be dropped from the \code{quitte}?}

\item{comment}{A character which at line start signifies the optional comment
header with metadata at the head of \code{file}.  The comment header, if
present, is returned as a \code{comment_header} attribute.  If multiple files
are read, the \code{comment_header} attribute is a list of comment headers with
file paths as names.}
}
\value{
A quitte data frame.
}
\description{
Reads IAMC-style .csv or .xlsx files into a quitte data frame.
}
\examples{
\dontrun{
read.quitte(c("some/data/file.mif", "some/other/data/file.mif"))
read.quitte("some/data/file.csv", sep = ",", quote = '"')
}

}
\author{
Michaja Pehl
}
