% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAddVariable.R
\name{calcAddVariable}
\alias{calcAddVariable}
\title{Calculate new variable}
\usage{
calcAddVariable(data, formula, newUnit = "None", na.act = "no")
}
\arguments{
\item{data}{A data frame with columns \code{"variable"}, \code{"unit"} and
\code{"value"}.}

\item{formula}{An object of class formula, as returned by
\code{\link[stats:formula]{stats::formula()}}.}

\item{newUnit}{Character vector with the unit for the newly calculated
variable.}

\item{na.act}{Indicates how NAs in the wide data frame should be handled.
Default "no" indicates no action is takenl.}
}
\value{
A data frame with the original and the new variables.
}
\description{
Calculate new variable from existing ones, using a generic formula.
}
\details{
\strong{Obsolete}. This function will be removed in the near future. Use
\code{\link[=calc_addVariable]{calc_addVariable()}} instead.
}
\examples{
\dontshow{
data <- inline.data.frame(c(
    "model;    scenario;   region;   variable;     unit;                 period;   value",
    "REMIND;   Baseline;   USA;      GDP|MER;      billion US$2005/yr;   2010;     12990",
    "REMIND;   Baseline;   USA;      Population;   million;              2010;       310.4",
    "REMIND;   Baseline;   USA;      PE;           EJ/yr;                2010;        91.62",
    "REMIND;   Baseline;   CHN;      GDP|MER;      billion US$2005/yr;   2020;      8882",
    "REMIND;   Baseline;   CHN;      GDP|MER;      billion US$2005/yr;   2010;      4119",
    "REMIND;   Baseline;   CHN;      Population;   million;              2020;      1387",
    "REMIND;   Baseline;   CHN;      Population;   million;              2010;      1349"))

calcAddVariable(data, formula("GDPpC" ~ "`GDP|MER` / Population"),
                newUnit = "US$2005/cap")
}

}
\seealso{
\code{\link[=calc_addVariable]{calc_addVariable()}}
}
\author{
Anselm Schultes, Michaja Pehl
}
