% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOyear.R
\name{ISOyear}
\alias{ISOyear}
\title{speedily converting years to POSIXct values}
\usage{
ISOyear(year)
}
\arguments{
\item{year}{Vector of years to convert to \link{POSIXct}.}
}
\value{
A vector of \link{POSIXct} values.
}
\description{
Converts integer years (e.g. \code{2023}) to \link{POSIXct} date/time values (e.g.
\verb{2023-07-02 12:00:00 GMT}) corresponding to July 2, noon, which is the middle
of the (non-leap) year.  The function keeps a cache of already converted
values, as the underlying function \code{\link[=ISOdate]{ISOdate()}} is rather slow.
}
\examples{
ISOyear(c(2005, 2010, 2100, 1900))
}
\author{
Michaja Pehl
}
