% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/qfratio-package.R
\name{p_A1B1_Ed}
\alias{p_A1B1_Ed}
\alias{p_A1B1_El}
\alias{p_A1B1_Ec}
\alias{d_A1I1_Ed}
\alias{p_imhof_Ed}
\alias{d_broda_Ed}
\alias{d_butler_Ed}
\alias{p_butler_Ed}
\alias{Ap_int_E}
\alias{ABpq_int_E}
\alias{ABDpqr_int_E}
\alias{ApIq_int_cE}
\alias{ApIq_int_nE}
\alias{ApIq_npi_cE}
\alias{ApIq_npi_nEd}
\alias{ApBq_int_E}
\alias{ApBq_npi_Ed}
\alias{ApBIqr_int_cEd}
\alias{ApBIqr_int_nEd}
\alias{ApBIqr_npi_Ed}
\alias{IpBDqr_gen_Ed}
\alias{ApBDqr_int_Ed}
\alias{ApBDqr_npi_Ed}
\alias{ApIq_npi_nEc}
\alias{ApBq_npi_Ec}
\alias{ApBIqr_int_nEc}
\alias{ApBIqr_npi_Ec}
\alias{IpBDqr_gen_Ec}
\alias{ApBDqr_int_Ec}
\alias{ApBDqr_npi_Ec}
\alias{ApIq_npi_nEl}
\alias{ApBq_npi_El}
\alias{ApBIqr_int_nEl}
\alias{ApBIqr_npi_El}
\alias{IpBDqr_gen_El}
\alias{ApBDqr_int_El}
\alias{ApBDqr_npi_El}
\alias{rqfpE}
\alias{qfrm_cpp}
\title{Internal C++ functions}
\usage{
p_A1B1_Ed(
  quantile,
  A,
  B,
  mu,
  m,
  stop_on_error,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

p_A1B1_El(
  quantile,
  A,
  B,
  mu,
  m,
  stop_on_error,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

p_A1B1_Ec(
  quantile,
  A,
  B,
  mu,
  m,
  stop_on_error,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

d_A1I1_Ed(quantile, LA, m, thr_margin = 100)

p_imhof_Ed(
  quantile,
  A,
  B,
  mu,
  autoscale_args,
  stop_on_error,
  tol_zero,
  epsabs,
  epsrel,
  limit
)

d_broda_Ed(
  quantile,
  A,
  B,
  mu,
  autoscale_args,
  stop_on_error,
  tol_zero,
  epsabs,
  epsrel,
  limit
)

d_butler_Ed(
  quantile,
  A,
  B,
  mu,
  order_spa,
  stop_on_error,
  tol_zero,
  epsabs,
  epsrel,
  maxiter
)

p_butler_Ed(
  quantile,
  A,
  B,
  mu,
  order_spa,
  stop_on_error,
  tol_zero,
  epsabs,
  epsrel,
  maxiter
)

Ap_int_E(A, mu, p_ = 1, thr_margin = 100, tol_zero = 2.2e-14)

ABpq_int_E(A, LB, mu, p_ = 1, q_ = 1, thr_margin = 100, tol_zero = 2.2e-14)

ABDpqr_int_E(
  A,
  LB,
  D,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  thr_margin = 100,
  tol_zero = 2.2e-14
)

ApIq_int_cE(A, p_ = 1, q_ = 1, thr_margin = 100)

ApIq_int_nE(A, mu, p_ = 1, q_ = 1, thr_margin = 100)

ApIq_npi_cE(
  LA,
  bA,
  p_ = 1,
  q_ = 1,
  m = 100L,
  error_bound = TRUE,
  thr_margin = 100
)

ApIq_npi_nEd(
  LA,
  bA,
  mu,
  p_ = 1,
  q_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 1L
)

ApBq_int_E(
  A,
  LB,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  m = 100L,
  error_bound = TRUE,
  thr_margin = 100,
  tol_zero = 2.2e-14
)

ApBq_npi_Ed(
  A,
  LB,
  bA,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBIqr_int_cEd(
  A,
  LB,
  bB,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  error_bound = TRUE,
  thr_margin = 100,
  tol_zero = 2.2e-14
)

ApBIqr_int_nEd(
  A,
  LB,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  error_bound = TRUE,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBIqr_npi_Ed(
  A,
  LB,
  bA,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

IpBDqr_gen_Ed(
  LB,
  D,
  bB,
  bD,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBDqr_int_Ed(
  A,
  LB,
  D,
  bB,
  bD,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBDqr_npi_Ed(
  A,
  LB,
  D,
  bA,
  bB,
  bD,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApIq_npi_nEc(
  LA,
  bA,
  mu,
  p_ = 1,
  q_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 1L
)

ApBq_npi_Ec(
  A,
  LB,
  bA,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBIqr_int_nEc(
  A,
  LB,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  error_bound = TRUE,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBIqr_npi_Ec(
  A,
  LB,
  bA,
  bB,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

IpBDqr_gen_Ec(
  LB,
  D,
  bB,
  bD,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBDqr_int_Ec(
  A,
  LB,
  D,
  bB,
  bD,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBDqr_npi_Ec(
  A,
  LB,
  D,
  bA,
  bB,
  bD,
  mu,
  p_ = 1,
  q_ = 1,
  r_ = 1,
  m = 100L,
  thr_margin = 100,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApIq_npi_nEl(
  LA,
  bA,
  mu,
  p_ = 1L,
  q_ = 1L,
  m = 100L,
  thr_margin = 100L,
  nthreads = 1L
)

ApBq_npi_El(
  A,
  LB,
  bA,
  bB,
  mu,
  p_ = 1L,
  q_ = 1L,
  m = 100L,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBIqr_int_nEl(
  A,
  LB,
  bB,
  mu,
  p_ = 1L,
  q_ = 1L,
  r_ = 1L,
  m = 100L,
  error_bound = TRUE,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBIqr_npi_El(
  A,
  LB,
  bA,
  bB,
  mu,
  p_ = 1L,
  q_ = 1L,
  r_ = 1L,
  m = 100L,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

IpBDqr_gen_El(
  LB,
  D,
  bB,
  bD,
  mu,
  p_ = 1L,
  q_ = 1L,
  r_ = 1L,
  m = 100L,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBDqr_int_El(
  A,
  LB,
  D,
  bB,
  bD,
  mu,
  p_ = 1L,
  q_ = 1L,
  r_ = 1L,
  m = 100L,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

ApBDqr_npi_El(
  A,
  LB,
  D,
  bA,
  bB,
  bD,
  mu,
  p_ = 1L,
  q_ = 1L,
  r_ = 1L,
  m = 100L,
  thr_margin = 100L,
  nthreads = 0L,
  tol_zero = 2.2e-14
)

rqfpE(nit, A, B, D, p_, q_, r_, mu, Sigma)
}
\arguments{
\item{quantile}{Scalar of quantile \eqn{q}, passed as \code{double}}

\item{A, B, D}{Argument matrices passed as \code{Eigen::Matrix}.
Symmetry is assumed.}

\item{mu}{Mean vector \eqn{\bm{\mu}}{\mu} for \eqn{\mathbf{x}}{x}
passed as \code{Eigen::Array}.  For \code{d_broda_Ed()},
assumed to be rotated by the eigenvectors of
\eqn{\mathbf{A} - q \mathbf{B}}{A - q B}}

\item{m}{Integer to specify the order of polynomials at which the series
expression is truncated.  Passed as \code{Eigen::Index}
(aka \code{std::ptrdiff_t} or \code{long long int})}

\item{stop_on_error}{\code{bool} to specify whether execution is stopped upon error in
numerical integration or root finding}

\item{thr_margin}{Optional argument to adjust the threshold for scaling.  See
\dQuote{Scaling} in \code{\link{d1_i}}.}

\item{nthreads}{\code{int} to specify the number of threads in \proglang{OpenMP}-enabled
functions.  See \dQuote{Multithreading} in \code{\link{qfrm}}.}

\item{tol_zero}{Tolerance against which numerical zero is determined}

\item{LA, LB}{Eigenvalues of the argument matrices passed as \code{Eigen::Array}}

\item{autoscale_args}{Factor to which the largest absolute eigenvalue of
\eqn{\mathbf{A} - q \mathbf{B}}{A - q B} is scaled, passed as \code{double}}

\item{epsrel, epsabs, limit, maxiter}{Optional arguments passed to \code{gsl_integration_qagi()} or
\code{gsl_root_test_delta()}}

\item{order_spa}{\code{int} to specify order of saddlepoint approximation}

\item{p_, q_, r_}{Exponents for \eqn{\mathbf{A}}{A}, \eqn{\mathbf{B}}{B}, and
\eqn{\mathbf{D}}{D}.
Passed as \code{double} or \code{long double}.}

\item{bA, bB, bD}{Scaling coefficients for \eqn{\mathbf{A}}{A}, \eqn{\mathbf{B}}{B},
and \eqn{\mathbf{D}}{D}.  Passed as \code{double} or \code{long double}.}

\item{error_bound}{\code{bool} to specify whether the error bound is returned}

\item{nit}{\code{int} to specify the number of iteration or sample size}

\item{Sigma}{Covariance matrix \eqn{\mathbf{\Sigma}}{\Sigma} for \eqn{\mathbf{x}}{x}.
Passed as \code{Eigen::Matrix}.}
}
\value{
All return a list via \code{Rcpp::List} of the following (as appropriate):
\describe{
\item{\code{$ans}}{Exact moment, from \code{double} or
\code{long double}}
\item{\code{$ansseq}}{Series for the moment, from
\code{Eigen::Array}}
\item{\code{$errseq}}{Series of errors, from \code{Eigen::Array}}
\item{\code{$twosided}}{Logical, from \code{bool}}
\item{\code{$dimnished}}{Logical, from \code{bool}}
}
}
\description{
These are internal \proglang{C++} functions called from corresponding \R
functions when \code{use_cpp = TRUE}.  Direct access by the user is \strong{not}
assumed.  All parameters are assumed to be appropriately structured.
}
\details{
\code{ApIq_int_nmE()} calls the \proglang{C} function
\code{gsl_sf_hyperg_1F1()} from \proglang{GSL} via \pkg{RcppGSL}.
}
\section{Functions}{
\itemize{
\item \code{p_A1B1_Ed()}: \code{pqfm_A1B1()}, double

\item \code{p_A1B1_El()}: \code{pqfm_A1B1()}, long double

\item \code{p_A1B1_Ec()}: \code{pqfm_A1B1()}, coefficient-wise scaling

\item \code{d_A1I1_Ed()}: \code{dqfm_A1I1()}

\item \code{p_imhof_Ed()}: \code{pqfm_imhof()}

\item \code{d_broda_Ed()}: \code{dqfm_broda()}

\item \code{d_butler_Ed()}: \code{dqfm_butler()}

\item \code{p_butler_Ed()}: \code{pqfm_butler()}

\item \code{Ap_int_E()}: \code{qfm_Ap_int()}

\item \code{ABpq_int_E()}: \code{qfpm_ABpq_int()}

\item \code{ABDpqr_int_E()}: \code{qfpm_ABDpqr_int()}

\item \code{ApIq_int_cE()}: \code{qfrm_ApIq_int()}, central

\item \code{ApIq_int_nE()}: \code{qfrm_ApIq_int()}, noncentral

\item \code{ApIq_npi_cE()}: \code{qfrm_ApIq_npi()}, central

\item \code{ApIq_npi_nEd()}: \code{qfrm_ApIq_npi()}, noncentral, double

\item \code{ApBq_int_E()}: \code{qfrm_ApBq_int()}

\item \code{ApBq_npi_Ed()}: \code{qfrm_ApBq_npi()}, double

\item \code{ApBIqr_int_cEd()}: \code{qfmrm_ApBIqr_int()}, central

\item \code{ApBIqr_int_nEd()}: \code{qfmrm_ApBIqr_int()}, noncentral, double

\item \code{ApBIqr_npi_Ed()}: \code{qfmrm_ApBIqr_npi()}, double

\item \code{IpBDqr_gen_Ed()}: \code{qfmrm_IpBDqr_gen()}, double

\item \code{ApBDqr_int_Ed()}: \code{qfmrm_ApBDqr_int()}, double

\item \code{ApBDqr_npi_Ed()}: \code{qfmrm_ApBDqr_npi()}, double

\item \code{ApIq_npi_nEc()}: \code{qfrm_ApIq_npi()}, noncentral, coefficient-wise scaling

\item \code{ApBq_npi_Ec()}: \code{qfrm_ApBq_npi()}, coefficient-wise scaling

\item \code{ApBIqr_int_nEc()}: \code{qfmrm_ApBIqr_int()}, noncentral, coefficient-wise scaling

\item \code{ApBIqr_npi_Ec()}: \code{qfmrm_ApBIqr_npi()}, coefficient-wise scaling

\item \code{IpBDqr_gen_Ec()}: \code{qfmrm_IpBDqr_gen()}, double

\item \code{ApBDqr_int_Ec()}: \code{qfmrm_ApBDqr_int()}, coefficient-wise scaling

\item \code{ApBDqr_npi_Ec()}: \code{qfmrm_ApBDqr_npi()}, coefficient-wise scaling

\item \code{ApIq_npi_nEl()}: \code{qfrm_ApIq_npi()}, noncentral, long double

\item \code{ApBq_npi_El()}: \code{qfrm_ApBq_npi()}, long double

\item \code{ApBIqr_int_nEl()}: \code{qfmrm_ApBIqr_int()}, noncentral, long double

\item \code{ApBIqr_npi_El()}: \code{qfmrm_ApBIqr_npi()}, long double

\item \code{IpBDqr_gen_El()}: \code{qfmrm_IpBDqr_gen()}, long double

\item \code{ApBDqr_int_El()}: \code{qfmrm_ApBDqr_int()}, long double

\item \code{ApBDqr_npi_El()}: \code{qfmrm_ApBDqr_npi()}, long double

\item \code{rqfpE()}: \code{rqfp()}

}}
