% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.0.R
\name{qser2ar}
\alias{qser2ar}
\title{Autoregression (AR) Model of Quantile Series}
\usage{
qser2ar(y.qser, p = NULL, order.max = NULL)
}
\arguments{
\item{y.qser}{matrix or array of pre-calculated QSER, e.g., using \code{qser()}}

\item{p}{order of AR model (default = \code{NULL}: selected by AIC)}

\item{order.max}{maximum order for AIC if \code{p = NULL} (default = \code{NULL}: determined by \code{stats::ar()})}
}
\value{
a list with the following elements:
  \item{A}{matrix or array of AR coefficients}
  \item{V}{vector or matrix of residual covariance}
  \item{p}{order of AR model}
  \item{n}{length of time series}
  \item{residuals}{matrix or array of residuals}
}
\description{
This function fits an autoregression (AR) model to quantile series (QSER) separately for each quantile level using \code{stats::ar()}.
}
