\name{unidim}
\alias{unidim}
\title{Several indices of the unidimensionality of a set of variables.}

\description{There are a variety of ways of assessing whether a set of items measures one latent trait.  \code{\link{unidim}} is just one more way.  If a one factor model holds in the data, then the factor analytic decomposition F implies that FF' should reproduce the correlations with communalities along the diagonal. In this case, the fit FF' should be identical to the correlation matrix minus the uniquenesses.  unidim is just the ratio of these two estimates.  The higher it is, the more the evidence for unidimensionality. A number of alternative statistics are estimated.

}
\usage{
unidim(keys=NULL,x=NULL,cor="cor",use="pairwise", fm="minres", correct=.5, 
       check.keys=TRUE,n.obs=NA)
}

\arguments{
  \item{x}{An input matrix or data frame.  If x is not a correlation matrix, then the correlations are found.}
  \item{keys}{If specified,  then a number of scales can be tested at once. (See \code{\link{scoreItems}} for a similar procedure.)}
\item{cor}{By default, find the Pearson correlation, other options are "spearman","kendall","tet"(for tetrachoric), "poly" (for polychoric), or  "mixed"}
\item{use}{pairwise complete cases is the default}
\item{fm}{factor extraction method defaults to "minres" but could be "mle" or "minrank"}
\item{correct}{If using "tetrachoric" or "polychoric" correlations, should we correct empty cells for continuity, and if so, by how much.  (See \code{\link{tetrachoric}} for a discussion of this correction)}
  \item{check.keys}{If TRUE, then items will be keyed based upon their loadings on the first factor.  Automatically done if key.list is NULL.}
  \item{n.obs}{Number of observartions.  If given a correlation matrix as input, n.obs is required for some of the goodness of fit estimates.}

}
\details{
This is set of new indices to test the unidimensionality of scale.  A number of test cases suggest that u provides high values when the data are in fact unidimensional, low values when they are not.

The logic is deceptively simple:  Unidimensionality implies that a one factor model of the data fits the covariances of the data.  If this is the case, then factor model implies R = FF' + U2 will have residuals of 0.  Similarly, this also implies that the observed correlations will equal the model.  Thus, the sum of the observed correlations (with the diagonal replaced by the communalities) should match the factor model.  Compare these two models:  R - U2  versus FF'.   This is the rho_c  estimate. It is basically a test of whether a congeneric model fits.  (That is, all the items have loadings on just one factor.)

This works well, but when some of the loadings are very small, even though 1 factor is correct, it is probably not a good idea to think of the items as forming a unidimen- sional scale. Thus, an alternative model (the Tau statistic) considers the residuals found by subtracting the average correlation from the observed correlations. This will achieve a maximum if the item covariances are all identical (a tau equivalent model).

The product of rho_c and Tau is the measure of unidimensionality, u That is, congeneric fit x tau equivalent fit as a measure of unidimensionality.
 
 The main unidim estimates of the results are reported in the uni object. Conventional factor goodness of fit are in the fa.stats object.
}
\value{ 
\item{u}{The estimate of unidimensionality which is just the product of}
\item{Tau}{The fit of the average r to the correlation matrix}
\item{rho_c}{The off diagonal fit from  \code{\link{fa}}  }
\item{alpha}{Standardized alpha of the keyed items (after appropriate reversals)}
\item{av.r}{The average interitem correlation of the keyed items.}
\item{median.r}{The median value of the iteritem correlations of the keyed items.}

\item{Unidim.A}{The unidimensional criterion when items are keyed in positive direction.}

\item{Unidim }{The raw value of the unidimensional criterion}
\item{raw.model}{The ratio of the FF' model to the sum(R)}
\item{adj.model}{The ratio of the FF' model to the sum(R) when items are flipped.}
\item{Total}{The ratio of the sum(R - uniqueness)/sum(R)}
\item{Total.A}{Same ratio with flipped items}
\item{CFI}{Comparative Fit Index}
\item{ECV}{Explained Common Variance}


}

\references{
Revelle, W. and Condon, D.M (2023) Using undim rather than omega in estimating undimensionality.  Working draft available at  \url{https://personality-project.org/revelle/publications/rc.23.pdf} 
}

\author{William Revelle}

\note{A perhaps interesting idea but still underdevelopment. Treat with appropriate caution.  It is (perhaps) useful to compare the unidim statistics with those generated by \code{\link{omega}}.  A quick way to do this is to use the \code{\link{reliability}} function which will find alpha, omega_h and omega_t as well as split half reliablities and the unidim measures.  When this done, it can be seen that u is not sensitive to the number of items and seems robust across various sample sizes.  
}


\seealso{ \code{\link{fa}} for factor analysis, \code{\link{omega}} and \code{\link{reliability}} for reliability.

}
\examples{
#test the unidimensionality of the five factors of the bfi data set.


unidim(psychTools::bfi.keys,psychTools::bfi) 
unidim(psychTools::ability.keys,psychTools::ability)
#Try a known 3 factor structure
x <- sim.minor(nfact=3,bipolar=FALSE)   #this makes all the items positive
unidim(x$model) 
keys.list <- list(first =paste0("V",1:4) ,second = paste0("V",5:8),
   third=paste0("V",9:12),all= paste0("V",1:12))
unidim(keys.list, x$model)

x <- sim.minor(nfact=3)
unidim(keys.list,x$model)   #we flip the negative items 

#what about a hierarchical model?
H <- sim.hierarchical()  # by default, a nice hierarchical model
H.keys <- list(First = paste0("V",1:3),Second=paste0("V",4:6),Third=paste0("V",7:9),
  All = paste0("V",1:9))
unidim(H.keys,H)



}


\keyword{ models }% at least one, from doc/KEYWORDS
\keyword{multivariate }% __ONLY ONE__ keyword per line