% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvt.R
\name{mapbox}
\alias{mapbox}
\alias{read_mvt_data}
\alias{read_mvt_sf}
\title{Mapbox Vector Tiles}
\usage{
read_mvt_data(data, as_latlon = TRUE, zxy = NULL)

read_mvt_sf(data, crs = 4326, zxy = NULL)
}
\arguments{
\item{data}{url, path or raw vector with the mvt data}

\item{as_latlon}{return the data as lat/lon instead of raw EPSG:3857 positions}

\item{zxy}{vector of length 3 with respectively z (zoom), x (column) and y (row).
For file/url in the standard \verb{../\{z\}/\{x\}/\{y\}.mvt} format, these are automatically
inferred from the input path.}

\item{crs}{desired output coordinate system (passed to \link[sf:st_transform]{sf::st_transform}).
Note that mvt input is always by definition 3857.}
}
\description{
Read Mapbox vector-tile (mvt) files and returns the list of layers.
}
