% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{clr_extract_chroma}
\alias{clr_extract_chroma}
\title{Extract HCL components}
\usage{
clr_extract_chroma(col)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}
}
\value{
Numeric vector of values.
}
\description{
Extract the hue, chroma, or luminance color components from a vector of
colors.
}
\details{
The range of the value are

- hue ranges from 0 to 360
- luminance ranges from 0 to 100
- chroma while depended on hue and luminance will roughly be within 0 and 180

Use [clr_extract()] if you are planning to extraction multiple components.
}
\examples{
clr_extract_hue(rainbow(100), "HCL")
clr_extract_chroma(rainbow(100))
clr_extract_luminance(rainbow(100))
}
\seealso{
Other Extraction: 
\code{\link{clr_extract_hue}()},
\code{\link{clr_extract_red}()},
\code{\link{clr_extract}()}
}
\concept{Extraction}
