% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.preferences.R
\name{group}
\alias{group}
\alias{group.preferences}
\alias{[.grouped_preferences}
\alias{format.grouped_preferences}
\title{Group Preferences}
\usage{
group(x, ...)

\method{group}{preferences}(x, index, ...)

\method{[}{grouped_preferences}(x, i, j, ...)

\method{format}{grouped_preferences}(x, max = 2L, width = 20L, ...)
}
\arguments{
\item{x}{A \code{\link{preferences}} object for \code{group()}; otherwise a
\code{grouped_preferences} object.}

\item{...}{Additional arguments passed on to
\code{\link{as.preferences}} by \code{grouped_preferences}; unused by
\code{format}.}

\item{index}{A numeric vector or a factor with length equal to the number of
preferences specifying the subject for each set.}

\item{i}{Indices specifying groups to extract, may be any data type accepted
by \code{[}.}

\item{j}{Indices specifying items to extract.
object, otherwise return a matrix/vector.}

\item{max}{The maximum number of preferences to format per subject.}

\item{width}{The maximum width in number of characters to format the
preferences.}
}
\value{
An object of class \code{grouped_preferences}, which is a vector of
of group IDs with the following attributes:
\item{preferences}{ The \code{preferences} object.}
\item{index}{ An index matching each preference set to each group ID.}
}
\description{
Create an object of class \code{grouped_preferences} which associates a
group index with an object of class \code{preferences}. This allows the
preferences to be linked to covariates with group-specific values.
}
\examples{

# ungrouped preferences (5 preference sets, 4 items)
R <- as.preferences(
  matrix(c(
    1, 2, 0, 0,
    0, 2, 1, 0,
    0, 0, 1, 2,
    2, 1, 0, 0,
    0, 1, 2, 3
  ), ncol = 4, byrow = TRUE),
  format = "ranking",
  item_names = LETTERS[1:4]
)
length(R)

# group preferences (first three in group 1, next two in group 2)
G <- group(R, c(1, 1, 1, 2, 2))
length(G)

## by default up to 2 preference sets are shown per group, "..." indicates if
## there are further preferences
G
print(G, max = 1)

## select preferences from group 1
G[1, ]

## exclude item 3 from preferences
G[, -3]

## Project preferences in all groups to their first preference
G[, 1, by.rank = TRUE]

## preferences from group 2, excluding item 3
## - note group 2 becomes the first (and only) group
G[2, -3]

# Group preferences by a factor
G <- group(R, factor(c("G1", "G1", "G1", "G2", "G2")))

G
print(G, max = 1)

## select preferences from group G1
G["G1"]

}
