% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm4_format_nfold.R
\name{format_nfold}
\alias{format_nfold}
\title{Create n-fold cross validation dataset from data frame}
\usage{
format_nfold(nfold_df, score_cols, lab_col, fold_col)
}
\arguments{
\item{nfold_df}{A data frame that contains at least one score column,
label and fold columns.}

\item{score_cols}{A character/numeric vector that specifies score columns
of \code{nfold_df}.}

\item{lab_col}{A number/string that specifies the label column
of \code{nfold_df}.}

\item{fold_col}{A number/string that specifies the fold column
of \code{nfold_df}.}
}
\value{
The \code{format_nfold} function returns a list that
  contains multiple scores and labels.
}
\description{
The \code{format_nfold} function takes a data frame with scores, label,
  and n-fold columns and convert it to a list for \code{\link{evalmod}}
  and \code{\link{mmdata}}.
}
\examples{

##################################################
### Convert dataframe with 2 models and 5-fold datasets
###

## Load test data
data(M2N50F5)
head(M2N50F5)

## Convert with format_nfold
nfold_list1 <- format_nfold(
  nfold_df = M2N50F5, score_cols = c(1, 2),
  lab_col = 3, fold_col = 4
)

## Show the list structure
str(nfold_list1)
str(nfold_list1$scores)
str(nfold_list1$labels)


##################################################
### Speficy a single score column
###

## Convert with format_nfold
nfold_list2 <- format_nfold(
  nfold_df = M2N50F5, score_cols = 1,
  lab_col = 3, fold_col = 4
)

## Show the list structure
str(nfold_list2)
str(nfold_list2$scores)
str(nfold_list2$labels)


##################################################
### Use column names
###

## Convert with format_nfold
nfold_list3 <- format_nfold(
  nfold_df = M2N50F5,
  score_cols = c("score1", "score2"),
  lab_col = "label", fold_col = "fold"
)

## Show the list structure
str(nfold_list3)
str(nfold_list3$scores)
str(nfold_list3$labels)

}
\seealso{
\code{\link{evalmod}} for calculation evaluation measures.
  \code{\link{mmdata}} for formatting input data.
  \code{\link{join_scores}} and \code{\link{join_labels}} for formatting
  scores and labels with multiple datasets.
}
